'use client'

import { cn } from '@/lib/utils'
import { Button } from '@/components/ui/button'
import { ScrollArea } from '@/components/ui/scroll-area'
import { 
  LayoutDashboard, 
  Users, 
  Search, 
  Brain, 
  BarChart3, 
  Settings,
  MapPin,
  Menu,
  X
} from 'lucide-react'

interface SidebarProps {
  isOpen: boolean
  onToggle: () => void
  activeTab: string
  onTabChange: (tab: string) => void
}

const navigation = [
  { id: 'overview', name: 'Overview', icon: LayoutDashboard },
  { id: 'social-media', name: 'Social Media', icon: Users },
  { id: 'seo', name: 'SEO Tools', icon: Search },
  { id: 'ai-tools', name: 'AI Tools', icon: Brain },
  { id: 'map', name: 'Live Map', icon: MapPin },
  { id: 'analytics', name: 'Analytics', icon: BarChart3 },
  { id: 'settings', name: 'Settings', icon: Settings },
]

export function Sidebar({ isOpen, onToggle, activeTab, onTabChange }: SidebarProps) {
  return (
    <>
      {/* Mobile backdrop */}
      {isOpen && (
        <div 
          className="fixed inset-0 bg-black bg-opacity-50 z-40 lg:hidden"
          onClick={onToggle}
        />
      )}
      
      {/* Sidebar */}
      <div className={cn(
        "fixed inset-y-0 left-0 z-50 w-64 bg-white shadow-lg transform transition-transform duration-300 ease-in-out lg:translate-x-0 lg:static lg:inset-0",
        isOpen ? "translate-x-0" : "-translate-x-full"
      )}>
        <div className="flex items-center justify-between h-16 px-6 border-b">
          <div className="flex items-center">
            <div className="w-8 h-8 bg-gradient-to-r from-purple-600 to-blue-600 rounded-lg flex items-center justify-center">
              <span className="text-white font-bold text-sm">SM</span>
            </div>
            <span className="ml-3 text-xl font-semibold text-gray-900">
              SocialBoost AI
            </span>
          </div>
          <Button
            variant="ghost"
            size="sm"
            onClick={onToggle}
            className="lg:hidden"
          >
            <X className="h-4 w-4" />
          </Button>
        </div>
        
        <ScrollArea className="flex-1 p-4">
          <nav className="space-y-2">
            {navigation.map((item) => {
              const Icon = item.icon
              return (
                <Button
                  key={item.id}
                  variant={activeTab === item.id ? "default" : "ghost"}
                  className={cn(
                    "w-full justify-start",
                    activeTab === item.id 
                      ? "bg-gradient-to-r from-purple-600 to-blue-600 text-white" 
                      : "text-gray-700 hover:text-gray-900 hover:bg-gray-100"
                  )}
                  onClick={() => {
                    onTabChange(item.id)
                    if (window.innerWidth < 1024) {
                      onToggle()
                    }
                  }}
                >
                  <Icon className="mr-3 h-4 w-4" />
                  {item.name}
                </Button>
              )
            })}
          </nav>
        </ScrollArea>
        
        <div className="p-4 border-t">
          <div className="bg-gradient-to-r from-purple-100 to-blue-100 rounded-lg p-4">
            <h4 className="text-sm font-semibold text-gray-900 mb-2">
              Pro Features
            </h4>
            <p className="text-xs text-gray-600 mb-3">
              Unlock advanced AI tools and analytics
            </p>
            <Button 
              size="sm" 
              className="w-full hover:scale-105 transition-transform"
              onClick={() => {
                console.log('Upgrade button clicked')
                alert('Upgrade to Pro functionality would be implemented here with payment processing')
              }}
            >
              Upgrade Now
            </Button>
          </div>
        </div>
      </div>
    </>
  )
}