'use client'

import { useState } from 'react'
import { Sidebar } from '@/components/dashboard/sidebar'
import { Header } from '@/components/dashboard/header'
import { OverviewTab } from '@/components/dashboard/tabs/overview-tab'
import { SocialMediaTab } from '@/components/dashboard/tabs/social-media-tab'
import { SeoTab } from '@/components/dashboard/tabs/seo-tab'
import { AiToolsTab } from '@/components/dashboard/tabs/ai-tools-tab'
import { MapTab } from '@/components/dashboard/tabs/map-tab'
import { AnalyticsTab } from '@/components/dashboard/tabs/analytics-tab'
import { SettingsTab } from '@/components/dashboard/tabs/settings-tab'

export default function Home() {
  const [activeTab, setActiveTab] = useState('overview')
  const [sidebarOpen, setSidebarOpen] = useState(false)

  const renderActiveTab = () => {
    switch (activeTab) {
      case 'overview':
        return <OverviewTab onTabChange={setActiveTab} />
      case 'social-media':
        return <SocialMediaTab />
      case 'seo':
        return <SeoTab />
      case 'ai-tools':
        return <AiToolsTab onTabChange={setActiveTab} />
      case 'map':
        return <MapTab />
      case 'analytics':
        return <AnalyticsTab />
      case 'settings':
        return <SettingsTab />
      default:
        return <OverviewTab />
    }
  }

  return (
    <div className="flex h-screen bg-background">
      <Sidebar 
        isOpen={sidebarOpen} 
        onToggle={() => setSidebarOpen(!sidebarOpen)}
        activeTab={activeTab}
        onTabChange={setActiveTab}
      />
      
      <div className="flex-1 flex flex-col overflow-hidden">
        <Header 
          onSidebarToggle={() => setSidebarOpen(!sidebarOpen)}
          sidebarOpen={sidebarOpen}
        />
        
        <main className="flex-1 overflow-x-hidden overflow-y-auto bg-gray-50">
          <div className="container mx-auto px-4 sm:px-6 py-4 sm:py-8">
            {renderActiveTab()}
          </div>
        </main>
      </div>
    </div>
  )
}