import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const userId = searchParams.get('userId')
    
    const socialAccounts = await db.socialAccount.findMany({
      where: userId ? { userId } : {},
      include: {
        user: true,
        posts: true,
        analytics: true
      }
    })
    
    return NextResponse.json(socialAccounts)
  } catch (error) {
    console.error('Error fetching social accounts:', error)
    return NextResponse.json({ error: 'Failed to fetch social accounts' }, { status: 500 })
  }
}

export async function POST(request: NextRequest) {
  try {
    const { platform, username, userId, accessToken, refreshToken } = await request.json()
    
    const socialAccount = await db.socialAccount.create({
      data: {
        platform,
        username,
        userId,
        accessToken,
        refreshToken
      }
    })
    
    return NextResponse.json(socialAccount, { status: 201 })
  } catch (error) {
    console.error('Error creating social account:', error)
    return NextResponse.json({ error: 'Failed to create social account' }, { status: 500 })
  }
}