import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const domainId = searchParams.get('domainId')
    
    const keywords = await db.keyword.findMany({
      where: domainId ? { domainId } : {},
      include: {
        domain: true,
        rankings: true,
        contents: true
      }
    })
    
    return NextResponse.json(keywords)
  } catch (error) {
    console.error('Error fetching keywords:', error)
    return NextResponse.json({ error: 'Failed to fetch keywords' }, { status: 500 })
  }
}

export async function POST(request: NextRequest) {
  try {
    const { keyword, volume, difficulty, intent, domainId } = await request.json()
    
    const keywordRecord = await db.keyword.create({
      data: {
        keyword,
        volume,
        difficulty,
        intent,
        domainId
      }
    })
    
    return NextResponse.json(keywordRecord, { status: 201 })
  } catch (error) {
    console.error('Error creating keyword:', error)
    return NextResponse.json({ error: 'Failed to create keyword' }, { status: 500 })
  }
}