import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'

export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const userId = searchParams.get('userId')
    
    const domains = await db.domain.findMany({
      where: userId ? { userId } : {},
      include: {
        user: true,
        keywords: true,
        rankings: true,
        contents: true,
        campaigns: true
      }
    })
    
    return NextResponse.json(domains)
  } catch (error) {
    console.error('Error fetching domains:', error)
    return NextResponse.json({ error: 'Failed to fetch domains' }, { status: 500 })
  }
}

export async function POST(request: NextRequest) {
  try {
    const { url, name, description, userId } = await request.json()
    
    const domain = await db.domain.create({
      data: {
        url,
        name,
        description,
        userId
      }
    })
    
    return NextResponse.json(domain, { status: 201 })
  } catch (error) {
    console.error('Error creating domain:', error)
    return NextResponse.json({ error: 'Failed to create domain' }, { status: 500 })
  }
}