#!/bin/bash

echo "📦 Deploying Next.js build to Android App"
echo "======================================="

# Check if we're in the main project directory
if [ ! -d "android-app" ]; then
    echo "❌ android-app directory not found. Please run from main project directory."
    exit 1
fi

# Check if Next.js build exists
if [ ! -d ".next" ]; then
    echo "🔨 Building Next.js application first..."
    npm run build
fi

if [ ! -d ".next" ]; then
    echo "❌ Next.js build not found. Please run 'npm run build' first."
    exit 1
fi

# Create target directory
TARGET_DIR="android-app/android/app/src/main/assets/server/public"
mkdir -p "$TARGET_DIR"

# Copy Next.js build files
echo "📋 Copying Next.js build files..."
cp -r .next/static "$TARGET_DIR/"
cp -r out/* "$TARGET_DIR/" 2>/dev/null || cp -r .next/* "$TARGET_DIR/" 2>/dev/null

# Copy public assets
if [ -d "public" ]; then
    cp -r public/* "$TARGET_DIR/"
fi

# Create a simple index.html if it doesn't exist
if [ ! -f "$TARGET_DIR/index.html" ]; then
    echo "📄 Creating fallback index.html..."
    cat > "$TARGET_DIR/index.html" << 'EOF'
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Social Media Trends</title>
    <script>
        // Redirect to main app
        window.location.href = '/_next/static/chunks/pages/_app.js';
    </script>
</head>
<body>
    <div id="root">
        <h1>Loading Social Media Trends...</h1>
        <p>If this page doesn't load, please check the server configuration.</p>
    </div>
</body>
</html>
EOF
fi

echo "✅ Deployment complete!"
echo "📱 Build the Android app with:"
echo "   cd android-app && npm run android"
echo ""
echo "📦 Or create release APK with:"
echo "   cd android-app && ./build.sh"