# Social Media Trends - Android App

A native Android application that runs a local Node.js server with the Social Media Trending Algorithm, providing AI-powered trend analysis and content generation directly on your device.

## 🚀 Features

- **Local Server**: Runs a complete Node.js server with Next.js on your Android device
- **AI-Powered Analysis**: Real-time social media trend analysis using ZAI SDK
- **Offline Capabilities**: Works without internet connection (AI features may require internet)
- **Native Performance**: Optimized for mobile with React Native WebView
- **Local Storage**: All data stored locally on device
- **Background Processing**: Server runs in background for continuous operation

## 📋 Requirements

### Development Environment
- **Node.js** 16+ 
- **Java** 11+
- **Android Studio** or **Android SDK**
- **React Native CLI**
- **Physical Android device** or **Emulator**

### Device Requirements
- **Android 5.0+** (API Level 21+)
- **Minimum 2GB RAM**
- **1GB+ storage space**
- **Internet connection** (for AI features)

## 🛠️ Installation

### 1. Clone and Setup

```bash
git clone <repository-url>
cd android-app
npm install
```

### 2. Android Setup

#### Set ANDROID_HOME environment variable:
```bash
export ANDROID_HOME=$HOME/Library/Android/sdk
export PATH=$PATH:$ANDROID_HOME/emulator
export PATH=$PATH:$ANDROID_HOME/tools
export PATH=$PATH:$ANDROID_HOME/tools/bin
export PATH=$PATH:$ANDROID_HOME/platform-tools
```

#### Create debug keystore:
```bash
cd android/app
keytool -genkey -v -keystore debug.keystore -storepass android -alias androiddebugkey -keypass android -keyalg RSA -keysize 2048 -validity 10000
```

### 3. Build and Run

#### Option A: Quick Build Script
```bash
./build.sh
```

#### Option B: Manual Build
```bash
# Install dependencies
npm install

# Start Metro bundler
npm start

# In another terminal, run on Android device
npm run android
```

#### Option C: Release APK
```bash
cd android
./gradlew assembleRelease

# Install APK on connected device
adb install app/build/outputs/apk/release/app-release.apk
```

## 🏗️ Architecture

### Native Layer (Android)
- **React Native**: Mobile app framework
- **WebView**: Renders the Next.js application
- **Native Module**: Manages Node.js server lifecycle
- **Background Service**: Keeps server running in background

### Server Layer (Node.js)
- **Express.js**: Web server framework
- **Next.js Build**: Pre-built React application
- **ZAI SDK**: AI integration for trend analysis
- **Local Storage**: File-based data persistence

### Application Layer (React)
- **Social Media Trends**: Main dashboard
- **AI Tools**: Content generation and analysis
- **SEO Tools**: Keyword research and optimization
- **Analytics**: Performance tracking

## 📱 Usage

### First Launch
1. Install the app on your Android device
2. Grant necessary permissions (storage, network)
3. Wait for server to initialize (30-60 seconds)
4. Access the web interface through the in-app WebView

### Features
- **Trend Analysis**: Analyze trending topics across social platforms
- **Content Generation**: Create AI-powered content based on trends
- **Keyword Research**: SEO keyword analysis and suggestions
- **Real-time Data**: Live updates on social media trends

## 🔧 Configuration

### Server Configuration
Edit `android/app/src/main/assets/server/server.js`:
```javascript
const PORT = process.env.PORT || 3000;
const HOST = process.env.HOST || '0.0.0.0';
```

### App Configuration
Edit `App.tsx` for UI and behavior changes:
```typescript
const serverUrl = await NodeServer.startServer();
```

## 🐛 Troubleshooting

### Common Issues

#### Server Won't Start
- Check device storage space
- Verify all permissions are granted
- Restart the application

#### WebView Not Loading
- Check server status in debug overlay
- Verify server files are properly extracted
- Check network security configuration

#### Build Errors
- Clear React Native cache: `npx react-native start --reset-cache`
- Clean Android build: `cd android && ./gradlew clean`
- Update Node.js to latest LTS version

### Debug Mode
Enable debug mode to see server logs:
```javascript
// In App.tsx
const DEBUG_MODE = true;
```

## 📦 App Structure

```
android-app/
├── android/
│   ├── app/
│   │   ├── src/main/
│   │   │   ├── java/com/socialmediatrends/
│   │   │   │   ├── ServerModule.java
│   │   │   │   ├── ServerPackage.java
│   │   │   │   └── MainApplication.java
│   │   │   ├── assets/server/
│   │   │   │   ├── package.json
│   │   │   │   └── server.js
│   │   │   └── res/
│   │   └── build.gradle
│   └── build.gradle
├── src/
│   ├── services/
│   │   ├── NodeServer.ts
│   │   └── StorageService.ts
│   └── App.tsx
├── package.json
├── metro.config.js
└── build.sh
```

## 🔒 Security

- **Local Only**: Server runs only on localhost
- **No External Access**: Network security config prevents external connections
- **Data Encryption**: Sensitive data encrypted at rest
- **Permission Control**: Minimal required permissions

## 📈 Performance

- **Startup Time**: ~30 seconds for server initialization
- **Memory Usage**: ~200-500MB depending on usage
- **Battery Impact**: Minimal when idle, moderate during AI processing
- **Storage**: ~100MB for app + server files

## 🔄 Updates

### Server Updates
1. Update files in `android/app/src/main/assets/server/`
2. Rebuild APK
3. Reinstall app

### App Updates
1. Update React Native code
2. Rebuild APK
3. Reinstall app

## 📞 Support

For issues and support:
1. Check troubleshooting section
2. Review device logs
3. Verify all requirements are met
4. Report issues with device details and logs

## 📄 License

This project is licensed under the MIT License - see the LICENSE file for details.

---

**Note**: This app bundles a complete Node.js server and runs it locally on your Android device. The server provides the same functionality as the web version but works entirely offline (except for AI features that require internet connectivity).