# SocialBoost AI - Social Media & SEO Management Platform

A comprehensive Next.js application for social media management and SEO optimization with AI-powered features.

## 🚀 Features

### Social Media Management
- **Multi-Platform Support**: Instagram, Twitter, Facebook, LinkedIn
- **Content Creation**: AI-powered content generation for posts
- **Media Upload**: Support for images and videos
- **Scheduling**: Schedule posts for optimal engagement times
- **Analytics**: Track engagement, reach, and performance metrics
- **Account Management**: Connect and manage multiple social accounts

### SEO Tools
- **Keyword Research**: AI-powered keyword analysis and suggestions
- **Ranking Tracker**: Monitor search engine rankings across locations
- **Content Optimizer**: AI-driven SEO content optimization
- **Geographic Targeting**: Track rankings by country, state, and city
- **Competitor Analysis**: Monitor competitor performance
- **Site Auditor**: Comprehensive SEO audits

### AI-Powered Features
- **Content Generation**: Create blog posts, social media content, product descriptions
- **Image Generation**: AI-generated visuals for social media
- **Video Scripts**: Automated video script creation
- **Content Optimization**: SEO and engagement optimization
- **Smart Analytics**: AI-powered insights and recommendations

### Analytics & Reporting
- **Dashboard Overview**: Comprehensive performance metrics
- **Platform Analytics**: Detailed social media analytics
- **SEO Performance**: Search engine optimization metrics
- **Audience Insights**: Demographics and engagement patterns
- **Custom Reports**: Export and share analytics

## 🛠 Technology Stack

- **Framework**: Next.js 15 with App Router
- **Language**: TypeScript 5
- **Styling**: Tailwind CSS 4 with shadcn/ui components
- **Database**: Prisma ORM with SQLite
- **AI Integration**: z-ai-web-dev-sdk for AI features
- **Real-time**: Socket.io for real-time updates
- **State Management**: Zustand and TanStack Query
- **Authentication**: NextAuth.js v4

## 📁 Project Structure

```
src/
├── app/
│   ├── api/                    # API routes
│   │   ├── users/             # User management
│   │   ├── social-accounts/   # Social media accounts
│   │   ├── social-posts/      # Social media posts
│   │   ├── domains/           # Domain management
│   │   ├── keywords/          # SEO keywords
│   │   ├── rankings/          # Search rankings
│   │   ├── content/           # Content management
│   │   ├── analytics/         # Analytics data
│   │   └── ai/                # AI-powered features
│   ├── globals.css
│   ├── layout.tsx
│   └── page.tsx               # Main dashboard
├── components/
│   ├── ui/                    # shadcn/ui components
│   └── dashboard/             # Dashboard components
│       ├── sidebar.tsx
│       ├── header.tsx
│       └── tabs/              # Tab components
├── hooks/                     # Custom React hooks
├── lib/                       # Utility functions
│   ├── db.ts                  # Database client
│   ├── socket.ts              # Socket.io configuration
│   └── utils.ts               # Utility functions
└── prisma/
    └── schema.prisma          # Database schema
```

## 🗄 Database Schema

The application uses a comprehensive database schema with the following main entities:

- **Users**: User accounts and profiles
- **SocialAccounts**: Connected social media accounts
- **SocialPosts**: Social media content and posts
- **SocialAnalytics**: Performance metrics and analytics
- **Domains**: Website domains for SEO tracking
- **Keywords**: SEO keywords and research data
- **Rankings**: Search engine ranking positions
- **Content**: AI-generated and managed content
- **SeoCampaigns**: SEO marketing campaigns

## 🚀 Getting Started

### Prerequisites

- Node.js 18+ 
- npm or yarn

### Installation

1. Clone the repository
2. Install dependencies:
   ```bash
   npm install
   ```

3. Set up the database:
   ```bash
   npm run db:push
   ```

4. Start the development server:
   ```bash
   npm run dev
   ```

5. Open [http://localhost:3000](http://localhost:3000) in your browser

## 📡 API Endpoints

### User Management
- `GET /api/users` - Get all users
- `POST /api/users` - Create new user

### Social Media
- `GET /api/social-accounts` - Get connected accounts
- `POST /api/social-accounts` - Connect new account
- `GET /api/social-posts` - Get social posts
- `POST /api/social-posts` - Create new post

### SEO Tools
- `GET /api/domains` - Get tracked domains
- `POST /api/domains` - Add new domain
- `GET /api/keywords` - Get keywords
- `POST /api/keywords` - Add keyword
- `GET /api/rankings` - Get ranking data
- `POST /api/rankings` - Add ranking data

### AI Features
- `POST /api/ai` - Generate AI content
- `POST /api/content` - Content management
- `GET /api/analytics` - Get analytics data

## 🤖 AI Features

The application integrates AI through the `z-ai-web-dev-sdk` for:

1. **Content Generation**: Create SEO-optimized articles, social media posts, and product descriptions
2. **Image Generation**: Generate custom images for social media
3. **Keyword Research**: AI-powered keyword suggestions and analysis
4. **Content Optimization**: Analyze and improve existing content
5. **Analytics Insights**: AI-driven recommendations

## 🎨 UI Components

The application uses shadcn/ui components for a consistent, modern interface:

- Responsive design with mobile-first approach
- Dark/light theme support
- Accessible components with ARIA support
- Smooth animations and transitions
- Interactive elements with hover states

## 📊 Analytics

Comprehensive analytics dashboard featuring:

- Real-time performance metrics
- Social media engagement tracking
- SEO ranking monitoring
- Audience demographics
- Geographic performance data
- Custom date range filtering

## 🔒 Security

- Secure API endpoints with proper validation
- Environment variable protection
- Secure database connections
- Input sanitization
- CSRF protection

## 🚀 Deployment

The application is ready for deployment on platforms like:

- Vercel (recommended for Next.js)
- Netlify
- AWS Amplify
- DigitalOcean

## 📝 License

This project is licensed under the MIT License.

## 🤝 Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## 📞 Support

For support and questions, please open an issue in the repository.

---

Built with ❤️ using Next.js, TypeScript, and modern web technologies.